{ This file creates and controls the main window of the modeling application.
  This window is called MainForm in the code. Describe the use of ReadytoRun and
  RunComplete here.}
unit frontend;

interface                      

uses
  Windows, Messages, SysUtils, Classes,
  Graphics, Controls, Forms, Dialogs,
  StdCtrls, Menus, stypes, ExtCtrls, TeeProcs, TeEngine, Chart, Mask, Printers;

const
  epsilon = 1e-8;
  accuracy = 0.0001;
  fullstep = 1;

type
  TMainForm = class(TForm)
    MainMenu1: TMainMenu;
    MIFiles: TMenuItem;
    MISaveParam: TMenuItem;
    DlgOpenParam: TOpenDialog;
    DlgSaveParam: TSaveDialog;
    MIEdit: TMenuItem;
    MIEditParam: TMenuItem;
    MIEditStates: TMenuItem;
    MIChooseDrv: TMenuItem;
    MIOutputFile: TMenuItem;
    DlgOpenDriver: TOpenDialog;
    MIChooseParam: TMenuItem;
    MICalculate: TMenuItem;
    MIView: TMenuItem;
    MIChart: TMenuItem;
    MIParamFile: TMenuItem;
    MIDriverFile: TMenuItem;
    MIEditDrv: TMenuItem;
    DlgSaveDriver: TSaveDialog;
    DlgSaveOutput: TSaveDialog;
    MISaveAsParam: TMenuItem;
    MIExit: TMenuItem;
    MIBar: TMenuItem;
    MITable: TMenuItem;
    DummyChart: TChart;
    ParamLabel: TLabel;
    DriverLabel: TLabel;
    OutputLabel: TLabel;
    StartLabel: TLabel;
    StopLabel: TLabel;
    PresentLabel: TLabel;
    MICalcSS: TMenuItem;
    MIEditDrv2: TMenuItem;
    MEStartTime: TMaskEdit;
    MEStopTime: TMaskEdit;
    ParamBox: TEdit;
    DriverBox: TEdit;
    OutputBox: TEdit;
    BtnRun: TButton;
    PresentBox: TEdit;
    BtnReload: TButton;
    MICalTime: TMenuItem;
    MIViewOutFile: TMenuItem;
    DlgOpenOutput: TOpenDialog;
    DlgPrint: TPrintDialog;
    EdNumSpecies: TEdit;       // MEL specific
    LblWelcome: TLabel;        // MEL specific
    LblDirections: TLabel;
    Run1: TMenuItem;
    MISpecialRun: TMenuItem;
    Help1: TMenuItem;
    MIAbout: TMenuItem;
    MINormalRun: TMenuItem;
    N1: TMenuItem;
    MIAutoChart: TMenuItem;
    N2: TMenuItem;
    MIOutOptions: TMenuItem;
    N3: TMenuItem;
    MITimeSteps: TMenuItem;     // MEL specific
    procedure ChooseParamFile(Sender: TObject);
    procedure ChooseDriver(Sender: TObject);
    procedure ChooseOutputFile(Sender: TObject);
    procedure BtnRunClick(Sender: TObject);
    procedure MIExitClick(Sender: TObject);
    procedure MISaveParamClick(Sender: TObject);
    procedure MISaveAsParamClick(Sender: TObject);
    procedure MIEditParamClick(Sender: TObject);
    procedure MIEditStatesClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure MeStartTimeExit(Sender: TObject);
    procedure MeStopTimeExit(Sender: TObject);
//    procedure MeTimeStepExit(Sender: TObject);
    procedure BtnReloadClick(Sender: TObject);
    procedure UpdateMainForm;
    procedure MIEditDrvClick(Sender: TObject);
    procedure MIAboutClick(Sender: TObject);
    procedure MICalcSSClick(Sender: TObject);
    procedure DisplayOutput(Sender: TObject);
    procedure SetNumSpecies(anEditBox: TEdit);     // MEL specific
    procedure EdNumSpecieschange(Sender: TObject);    // MEL specific
    procedure EdNumSpeciesExit(Sender: TObject);      // MEL specific
    procedure MICalTimeClick(Sender: TObject);
    procedure MIViewOutFileClick(Sender: TObject);
    procedure MEStopTimeKeyPress(Sender: TObject; var Key: Char);
    procedure MEStartTimeKeyPress(Sender: TObject; var Key: Char);
    procedure MIOpenOptionsClick(Sender: TObject);
    procedure MINormalRunClick(Sender: TObject);
    procedure MIAutoChartClick(Sender: TObject);
    procedure ParamBoxKeyPress(Sender: TObject; var Key: Char);
    procedure DriverBoxKeyPress(Sender: TObject; var Key: Char);
    procedure OutputBoxKeyPress(Sender: TObject; var Key: Char);
    procedure EdNumSpeciesKeyPress(Sender: TObject; var Key: Char);
  private
    { Private declarations }
    initialstates:statearray;
    procedure ResetStatesNow(Sender: TObject);
  public
    { Public declarations }
    RunningInteractive: Boolean;
    lastitem: TComponent;
    CurrentResid: Double;
    BeginningofRun: Boolean;
    procedure ShowProgressBar;
    procedure CancelRun;
 end;

var
  MainForm: TMainForm;
  time,time_start,Time_stop,CalTime: double;
  ModelDef: TModelDef;
  stat: statearray;
  drive: drivearray;
  par: paramarray;
  proc: processarray;
  paramfilename,driverfilename,outfilename: string;
  NeedToSavePar: Boolean = False;
  ReadyToRun: Boolean = False;
  RunComplete: Boolean = False;
  NewParamFile: Boolean;
  NewDriverFile: Boolean;
//  accuracy:double;
  stopRun: boolean = false;
//  NumSpProc,NumSpPar:integer;     // MEL specific
//  numspp:integer;                 // MEL specific
implementation

uses fileio, Calculate, display, ReloadDlg, params, data,
     equations, integrator, note, aboutbox, trouble, ProgressBar, Options;

{$R *.DFM}

{ This procedure sets up the modeling application. }
procedure TMainForm.FormCreate(Sender: TObject);
var
 tempstring: string;
begin
  ForceCurrentDirectory := True;
// Set initial values for model timing
//  accuracy := 1e-8;
  Time_start := strtofloat(MEStartTime.text);
  Time_stop := strtofloat(MEStopTime.text);
//  Time_step := Strtofloat(METimeStep.text);
  CalTime := time_start;
// Set initial value for the number of species
//  numspp := 1;          // MEL specific

{ Call the counts procedure which defines the model structure. This procedure
  sets the names and units of the state variables, driver variables, process
  variables, and parameters. It also sets the values of the ModelDef structure
  which defines the number of state variables, driver variables, process
  variables and parameters.
}
  counts;
  Application.Title := ModelDef.modelname;
  next_drive := drive; // Initialize names and units of next_drive & last_drive
  last_drive := drive;
  MainForm.Caption := ModelDef.modelname;  // Set the MainForm caption
  tempstring := Application.Title;
  tempstring := lowercase(tempstring);
{  if (tempstring = 'modelbatch') or (tempstring = 'sensitivity') or
                    (tempstring = 'montecarlo') then
     RunningInteractive := False
  else                               Better to set RunningInteractive in modelbatch or sensitivity etc.  }
  RunningInteractive := True;
  BeginningofRun := True;
end;

{ This procedure enables the user to choose a parameter file using several
  different methods. The user can click Choose Parameter file from the menu,
  click on the label Parameter File, or type a filename directly in the box.
  If the user chooses using either the menu or the label, an open file dialog
  is displayed. }
procedure TMainForm.ChooseParamFile(Sender: TObject);
var
 oldparamfilename : string;
 replace: Word;
begin
 oldparamfilename := paramfilename;
 // If the user typed directly in the box
 if Sender is TEdit then paramfilename := parambox.text  // Set paramfilename
 else if RunningInteractive then // The user used either the menu or clicked on the label
   begin  // Show the open file dialog
           // First set the dialog box default filename to the current paramfile
      DlgOpenParam.filename := paramfilename;
          // If the user chooses OK in the dialog then set the new paramfilename
      if DlgOpenParam.execute then paramfilename := DlgOpenParam.filename;
   end;

 if (paramfilename <> oldparamfilename) or not RunningInteractive then
  begin
   if paramfilename <> '' then  // Be sure something was entered for the filename
    begin
     try
      if not FileExists(paramfilename) then  // If the paramter file doesn't exist
        // Create a new parameter file using values in memory
       begin
        WriteParamFile(paramfilename, ModelDef.numparam, par, ModelDef.numstate,
                        stat, currentresid);
        NewParamFile := True;
       end
      else // Parameter does exist, so read it into the global arrays.
       begin
        if oldparamfilename <> '' then
         replace := MessageDlg('Replace current values with those in file, ' +
            paramfilename + ' ?', mtConfirmation, [mbYes,mbNo], 0)
        else
         replace := mryes;
        if replace = mryes then
         begin
           ReadParamFile(paramfilename,ModelDef.numparam,par,ModelDef.numstate,
                         stat, currentresid);
           NewParamFile := False;  // fix should this be true???
         end
        else
         begin
           paramfilename := oldparamfilename;
//           NewParamFile := False;  // fix necessary here and if so what should the value be???
         end;
{        if ReadParamFile(paramfilename,ModelDef.numparam,par,ModelDef.numstate,
                         stat, currentresid) then
          NewParamFile := False
        else
         begin
          for i := 1 to ModelDef.numstate do stat[i].value := 0;
          for i := 1 to ModelDef.numparam do par[i].value := 0;
          paramfilename := '';
         end;  }
       end;
     except
      paramfilename := oldparamfilename;
      raise;
     end;
    end;
   RunComplete := False;
   Readytorun := false;   // Can't run the model.
  end;

 UpdateMainForm;  // Update the form
end;

{ This procedure enables the user to choose a Driver file using several
  different methods. The user can click Choose Driver file from the menu,
  click on the label Driver File, or type a filename directly in the box.
  If the user chooses using either the menu or the label, an open file dialog
  is displayed. }
procedure TMainForm.ChooseDriver(Sender: TObject);
var
 olddriverfilename : string;
 i:integer;
begin
 olddriverfilename := driverfilename;
// If the user typed directly in the edit box
 if Sender is TEdit then driverfilename:=DriverBox.text  // Set the driverfile
 else  // User used the menu or clicked on the Driver label
  begin   // Show the open file dialog
    // First set the default filename to the current driverfile
   DlgOpenDriver.filename := driverfilename;
    // Show the dialog and if the user clicks OK, set the new driver filename
   if DlgOpenDriver.execute then
    begin
//      if FileExists(DlgOpenDriver
      driverfilename := DlgOpenDriver.filename;
    end;
  end;

 if driverfilename <> olddriverfilename then
  begin
   if driverfilename <> '' then
     if not FileExists(driverfilename) then
      begin
       NewDriverFile := True;
       for i := 1 to ModelDef.numdrive do drive[i].value := 0;
       OpenDriverFile(driverfilename,ModelDef.numdrive,drive,flwrite);
       WriteDriverFile(time,ModelDef.numdrive,drive);
       CloseDriverFile;
      end
     else
       NewDriverFile := False;
   ReadytoRun := False; // This forces the edit boxes on the mainform to be update with the new filename
   RunComplete := False;
  end;

 UpdateMainForm;
end;

{ This procedure enables the user to choose an Output file using several
  different methods. The user can click Choose Output file from the menu,
  click on the label Output File, or type a filename directly in the box.
  If the user chooses using either the menu or the label, an open file dialog
  is displayed. }
procedure TMainForm.ChooseOutputFile(Sender: TObject);
var
 oldoutfilename : string;
begin     // If the user typed directly in the edit box
 oldoutfilename := outfilename;

 if Sender is TEdit then  Outfilename := OutputBox.text  // Set the output file
 else   // User used the menu or clicked on the Output label
  begin  // Show the Save file dialog
    // First set the default filename to the current output file.
   DlgSaveOutput.filename := outfilename;
   // Show the dialog and if the user chooses OK, set the outfilename to the new file.
   if DlgSaveOutput.execute then outfilename := DlgSaveOutput.filename;
  end;

{  if outfilename <> oldoutfilename then
  begin
  if outfilename <> '' then  // Make sure a value was entered for the filename
    begin
     if FileExists(outfilename) then  // If the file already exists
      // Confirm that the user wants to overwrite the existing file.
       if MessageDlg('Overwrite existing output file, ' + outfilename + '?',
                  mtConfirmation, [mbYes,mbNo], 0) = mrNo then
        begin
          outfilename := '';  // Set the outfile to no value
        end;
    end;              
  end;                 }
 RunComplete := False;
 ReadytoRun := False;  // Can't run without an output file.
 UpdateMainForm; // Update the form.
end;

{ This procedure saves the current values of the state variables and the
  parameters to the current parameter file. }
procedure TMainForm.MISaveParamClick(Sender: TObject);
begin
 WriteParamFile(paramfilename, ModelDef.numparam, par, ModelDef.numstate, stat,
                currentresid);
 RunComplete := False;
 NewParamFile := False;
 UpdateMainForm;
 Beep;
end;

{ Procedure to save the state variables and parameters to a new parameter file. }
procedure TMainForm.MISaveAsParamClick(Sender: TObject);
begin  // Show the Save dialog
with DlgSaveParam do
 begin
  // Set the default filename in save dialog to the current parameter file.
  filename := paramfilename;
  if execute then   // If the user chooses OK in the save dialog.
   begin
    paramfilename:=filename; // Set the paramfilename to the new filename.
    // Save the state variables and parameters to the current file.
    WriteParamFile(paramfilename, ModelDef.numparam, par, ModelDef.numstate, 
                stat, currentresid);
    // Set Ready to Run to false so the the edit boxes on the form will be
    // updated when UpdateMainForm is called.
    NewParamFile := False;
    ReadytoRun := False;
    RunComplete := False;
    UpdateMainForm;  // Update the form.
   end;
 end;
end;

{ Procedure to allow the user to edit the parameter values. This procedure calls
  the Parameter Form defined in the params.pas unit. While the user is editing
  the parameters the MainForm is disabled. }
procedure TMainForm.MIEditParamClick(Sender: TObject);
begin
{ Show the parameter form. If the user clicked OK on the parameter form,
  meaning they changed the parameter values, update this form. }
 if FmParameter.showmodal = mrOK then      //fix
  begin
// Parameters have been changed so any previous model runs are invalid.
   RunComplete := False;
   UpdateMainForm;   // Update the form.
//   currentresid := 999;
  end;
end;

{ Procedure to allow the user to edit the state variables. This procedure calls
  the Data Form defined in the data.pas unit. While the user is editing
  the state variables the MainForm is disabled. }
procedure TMainForm.MIEditStatesClick(Sender: TObject);
begin
 DataForm.ShowStates;  // Show the data form containing state variables
 UpdateMainForm;  // Update the form.
end;

{ Procedure to allow the user to edit the driver variables. This procedure calls
  the Note Form defined in the note.pas unit. While the user is editing
  the drivers the MainForm is disabled. }
procedure TMainForm.MIEditDrvClick(Sender: TObject);
begin
{ Show the note form. If the user clicked OK on the note form,
  meaning they changed the driver values, update this form. }
 if FmNote.ShowModal = mrOK then
  begin
// Drivers have been changed so any previous model runs are invalid.
   RunComplete := False;
// User may have changed driver files, so force the edit boxes and menu to be updated.
   ReadytoRun := False;
   UpdateMainForm;  // Update the form.
  end;
end;

{ Procedure to process changes made to the start time mask edit box. The mask
  edit box only allows numeric input with up to 5 digits. Values entered must be
  integers. To change the allowed values modify the mask using the object
  inspector. }
procedure TMainForm.MeStartTimeExit(Sender: TObject);
begin
 if (MEStartTime.text <> '') and (MeStartTime.Modified) then 
  begin
   Time_Start := strtofloat(MEStartTime.text); // Set the start time of the model.
   ReadytoRun := False;  // Force checking of start and stop times in UpdateMainForm.
   RunComplete := False;  // Previous runs are invalid.
   UpdateMainForm;   // Update the form.
  end;
end;

{ Procedure to process changes made to the start time mask edit box. The mask
  edit box only allows numeric input with up to 5 digits. Values entered must be
  integers. To change the allowed values modify the mask using the object
  inspector. }
procedure TMainForm.MeStopTimeExit(Sender: TObject);
begin
 if (MEStopTime.text <> '') and (MeStopTime.Modified) then
  begin
   Time_Stop := strtofloat(MEStopTime.text); // Set the stop time of the model.
   ReadytoRun := False; // Force checking of start and stop times in UpdateMainForm.
   RunComplete := False;  // Previous runs are invalid.
   UpdateMainForm;   // Update the form.
  end;
end;

{ This procedure shows the output from the model run in table or chart format.
  It uses the form defined in display.pas. }
procedure TMainForm.DisplayOutput(Sender: TObject);
begin
 if (Sender as TMenuItem).Name = 'MITable' then
  FmDisplayData.DisplayStyle := dsTable // Set the type of display.
 else
  FmDisplayData.DisplayStyle := dsChart;
 FmDisplayData.showmodal; // Show the Display Form.

 end;

{ Show an about box containing general information about the model. }
procedure TMainForm.MIAboutClick(Sender: TObject);
begin
 FmAbout.Caption := 'About ' + ModelDef.modelname;
 FmAbout.LblModel.Caption := ModelDef.modelname;
 FmAbout.LblVersion.Caption := ModelDef.versionnumber;
 FmAbout.MoContact.Lines.Add(ModelDef.contactperson);
 FmAbout.MoContact.Lines.Add(ModelDef.contactaddress1);
 FmAbout.MoContact.Lines.Add(ModelDef.contactaddress2);
 FmAbout.MoContact.Lines.Add(ModelDef.contactaddress3);
 FmAbout.ShowModal;
end;

{ This procedure presents a dialog which allows the user to reread the state
  variables and/or parameters from the parameter form. It uses the Reload
  dialog defined in the ReloadDlg.pas unit.}
procedure TMainForm.BtnReloadClick(Sender: TObject);
begin  // Show the Reload Dialog
if paramfilename <> '' then
 begin
  if DlgReload.ShowModal = mrOK then  // If the user clicked OK, values were reloaded
   begin
    RunComplete := False; // so previous runs are invalid.
    UpdateMainForm;  // Update the form.
   end;
 end
else
  MessageDlg('Invalid parameter file. No values reloaded.',mtWarning,[mbOK],0);
end;

// This procedure is used to update the controls on the Main Form, i.e. enabling
// and disabling them when appropriate.
procedure TMainForm.UpdateMainForm;
begin
 if not ReadytoRun then
  begin
//   time := 0;
//   PresentBox.Text := floattostr(time);
   ParamBox.text := paramfilename; // save it's name in the paramfilename variable
   if paramfilename <> '' then // if a parameter file has been chosen
    begin
     MISaveParam.Enabled := true;  // enable the save parameter file menu item
    end;
     // if a driver variable has been chosen, save it's name to driverfilename
   if driverfilename <> '' then DriverBox.text := driverfilename;
    // if an output file name has been chosen, save it's name to outfilename
   if outfilename <> '' then OutputBox.text := outfilename;
// If all files have been chosen then enable the run button and calculate menu.
   if (DriverBox.text <> '') and (ParamBox.text <> '') then
     begin
//       MICalculate.enabled := true; // Enable the calculate menu
       if (OutputBox.text <> '') and (Time_stop > Time_start) then
         begin
          ReadytoRun := true;
          BtnRun.enabled := true;
          FmOptions.RunOptions.stepcounter := FmOptions.DefaultRunOptions.stepcounter;
         end;
     end;
  end;
 if RunComplete then  // If a run is complete
  begin
   MIChart.Enabled := true;  // Enable the chart output menu item
   MITable.Enabled := true;  // Enable the table output menu item
   last_time := 0;
   next_time := 0;
  end
 else
  begin // Run is not complete or previous run is now invalid
   MIChart.Enabled := False;  // Disable the chart output menu item.
   MITable.Enabled := False;  // Disable the table output menu item.
   PresentBox.Text := floattostr(0); // Set the present time to 0
//   if Application.ExeName = 'modelbatch.exe' then
//     FmDisplayData.NeedtoReadData := True;// Tell display form the new data will need to be read in.
  end;
 if MainForm.ActiveControl is TEdit then
   if MainForm.ActiveControl.Name = 'ParamBox' then
    MainForm.ActiveControl := DummyChart;
 if FmOptions.RunOptions.NormalRun then
   MINormalRun.Checked := True
 else
   MISpecialRun.Checked := True;
end;

// This procedure controls the actual running of a model scenario.
procedure TMainForm.BtnRunClick(Sender: TObject);
var
  j, outputfreq, stepsperfullstep, nok, nbad:integer;
  tempstat:yValueArray;
  drivetime, nextstep, remainder, errorest, SStest, SSstep, temp:double;
  steadystate, ResetDriverFile: Boolean;
  previousstat: statearray;
begin
 BeginningofRun := True;
 ResetDriverFile := False;
 if RunningInteractive then
  begin
   ShowProgressBar;
   MainForm.Enabled := False;
   FmDisplayData.Enabled := False;
   FmDisplayData.NeedtoReadData := true;
  end;
 if MIAutoChart.Checked = true then FmDisplayData.autoShowChart := true;
 stepsperfullstep := round(fullstep/FmOptions.RunOptions.Time_step);
 initialstates := stat;
 last_time := 0;
 next_time := 0;
 OpenDriverFile(driverfilename,ModelDef.numdrive,drive,flread);
 OpenOutputFile(Outfilename,ModelDef.numstate,stat,ModelDef.numprocess,proc,flWrite);
 nextstep := FmOptions.RunOptions.Time_step;
 time := time_start;
 if FmOptions.RunOptions.RepeatDrivers then
   drivetime := time - FmOptions.RunOptions.RepeatDriveTime*
          int(time/FmOptions.RunOptions.RepeatDriveTime)
 else
   drivetime := time_start;
 steadystate := false;
// Variables used to keep track of when to write to output file
 outputfreq := round(FmOptions.RunOptions.Outputstep/FmOptions.RunOptions.Time_step);
// Calculate and write out the initial state of system.
 GetCurrentDrivers(drivetime,drive);
 processes(time,drivetime,drive,par,stat,proc,false);
 if (not FmOptions.RunOptions.AppendOutputFile) and
    (not FmOptions.RunOptions.OutputEORonly) and
   { (FmOptions.RunOptions.OutputStep = FmOptions.RunOptions.Time_step) and }  // Commented out because time_step=0.2, outstep = 1 doesn't work and not sure why it's here
    (FmOptions.RunOptions.Outputoffset = FmOptions.DefaultRunOptions.Outputoffset) then
    WriteOutputFile(time_start-fullstep,ModelDef.numstate,stat,ModelDef.numprocess,proc);  // use zero as time to indicate these are the inital conditions
//  randomize;      // MEL specific
 previousstat := stat;
 try try
  while (time < time_stop + fullstep) and (not steadystate) do
    begin
      for j:=1 to ModelDef.numstate do tempstat[j] := stat[j].value;
      odeIntegrator(tempstat, modeldef.numstate, time, time+FmOptions.RunOptions.Time_step, drivetime,
           accuracy, nextstep, 0.000001*FmOptions.RunOptions.Time_step, nok, nbad, drive, par);
      for j:=1 to ModelDef.numstate do stat[j].value := tempstat[j];
      temp := abs((time+FmOptions.RunOptions.Time_step)/FmOptions.RunOptions.DiscreteStep -       // time
                round((time+FmOptions.RunOptions.Time_step)/FmOptions.RunOptions.DiscreteStep));   // time
      BeginningofRun := False;
      if temp > epsilon then
         processes(time, drivetime, drive, par, stat, proc, false)
      else
         processes(time, drivetime, drive, par, stat, proc, true);
// Write output
      FmOptions.RunOptions.outcounter := FmOptions.RunOptions.outcounter + 1;
      if not FmOptions.RunOptions.OutputEORonly then
       begin
         if (time >= FmOptions.RunOptions.Outputoffset) then
           begin
             if (time = FmOptions.RunOptions.Outputoffset)
                or (FmOptions.RunOptions.outcounter = outputfreq) then
               begin
          {       if (FmOptions.RunOptions.Time_step <> FmOptions.DefaultRunOptions.Time_step)
                   and (stepsperfullstep = fullstep) then
                     WriteOutputFile(time-(FmOptions.RunOptions.outcounter-1)*
                         FmOptions.RunOptions.time_step,ModelDef.numstate,stat,
                         ModelDef.numprocess,proc)
                 else }
                 if (stepsperfullstep <> fullstep)  and
                  (FmOptions.RunOptions.time_step <> FmOptions.RunOptions.Outputstep) then
                     WriteOutputFile(time-(stepsperfullstep-1)*
                         FmOptions.RunOptions.time_step,ModelDef.numstate,stat,
                         ModelDef.numprocess,proc)
                 else
                     WriteOutputFile(time,ModelDef.numstate,stat,ModelDef.numprocess,proc);
                 FmOptions.RunOptions.outcounter := FmOptions.DefaultRunOptions.outcounter;
               end;
           end
         else
           begin
             FmOptions.RunOptions.outcounter := FmOptions.DefaultRunOptions.outcounter;
           end;
       end
      else    // Output EOR only
       begin
         if time >= time_stop then
           WriteOutputFile(time, ModelDef.numstate,stat,ModelDef.numprocess,proc);
       end;
// Update progress bar
      if RunningInteractive then
           FmProgress.PbRunStatus.Position := (round(time - time_start)*100)
                           div round(time_stop - time_start);
{      if (time<time_stop) and (time > time_stop+epsilon)
               then FmOptions.RunOptions.Time_step:=time_stop-time; }// Necessary? Gives a funny end maybe
                                               // should time really be time+FmOptions.RunOptions.Time_step?    fix
// Reset State variables option
      if FmOptions.RunOptions.ResetStates then
        begin
          remainder := time/FmOptions.RunOptions.ResetStateTime -
                                  int(time/FmOptions.RunOptions.ResetStateTime);
          if remainder < FmOptions.RunOptions.Time_step/FmOptions.RunOptions.ResetStateTime then
            begin
             MainForm.ResetStatesNow(BtnRun);
            end;
        end;
// Run to steady state option
      if FmOptions.RunOptions.RuntoSS then
        begin
          SSstep := (FmOptions.RunOptions.Time_step - FmOptions.RunOptions.SSTime*
                    (round(FmOptions.RunOptions.Time_step/FmOptions.RunOptions.SSTime)));
          SStest := (time - FmOptions.RunOptions.SSTime*
                    (round(time/FmOptions.RunOptions.SSTime)));
          if (SStest >= 0) and (SStest < SSstep) then
           begin
             steadystate := true;
             for j := 1 to ModelDef.numstate do
              begin
                if stat[j].value > 0 then
                   errorest := abs(previousstat[j].value -
                                                  stat[j].value)/stat[j].value
                else
                   errorest := 0;   // fix
                if errorest <= FmOptions.RunOptions.SSCriteria then
                  steadystate := steadystate and true
                else
                  steadystate := steadystate and false;
              end;
              previousstat := stat;
             // If outputEORonly then modify time_stop and steadystate so that
             // loop executes one more time and then outputs results.
             if steadystate and FmOptions.RunOptions.OutputEORonly then
              begin
                steadystate := false;
                time_stop := time + FmOptions.RunOptions.Time_step;
              end;
           end;
        end;
// Next time step
      time := time_start + FmOptions.RunOptions.stepcounter*FmOptions.RunOptions.Time_step;
      FmOptions.RunOptions.stepcounter := FmOptions.RunOptions.stepcounter + 1;
// Repeat drivers option
      if ResetDriverFile then
       begin
        last_time := 0;     next_time := 0;       ResetDriverFile := False;
       end;
      if FmOptions.RunOptions.RepeatDrivers then
        drivetime := time - FmOptions.RunOptions.RepeatDriveTime*
          int(time/FmOptions.RunOptions.RepeatDriveTime)
      else
        drivetime := time;
      if drivetime = 0 then
       begin
        drivetime := FmOptions.RunOptions.RepeatDriveTime;
        ResetDriverFile := True;
       end;
//      GetCurrentDrivers(drivetime,drive);
// check for pending messages (for example, the cancel button)
      application.ProcessMessages;
      if stopRun then break;
    end;
 finally
  stopRun := false;
  CloseDriverFile;
  CloseOutputFile;
  RunComplete := True;
  FmOptions.RunOptions.stepcounter := FmOptions.DefaultRunOptions.stepcounter;
  FmOptions.RunOptions.outcounter := FmOptions.DefaultRunOptions.outcounter;
  ResetStatesNow(BtnRun);
  if RunningInteractive then
   begin
    FmDisplayData.FileName := outfilename;
    UpdateMainForm;
    MainForm.Enabled := True;
    FmDisplayData.Enabled := True;
    PresentBox.Text := floattostrf(Time,ffgeneral,5,1);
    FmProgress.Hide;
    if (FmDisplayData.autoShowChart = true) and (not FmDisplayData.Visible) then
      DisplayOutput(MIChart);
   end;
 end;
 except
{  on EUserCancel do
   begin

   end; }
  on E: Exception do
   begin
   if RunningInteractive then
    begin
     FmTrouble.MmError.Lines.Clear;
     FmTrouble.MmError.Lines.Add(E.Message);
     FmTrouble.ShowModal;
    end
    else
     raise;
   end;
 end;
end;

procedure TMainForm.MIExitClick(Sender: TObject);
var
  answer:word;
begin
  if NeedToSavePar = True then
        begin
          answer := MessageDlg('Save parameter file before exiting?',
                 mtConfirmation, mbYesNoCancel, 0);
          if answer <> mrCancel then
           if answer = mrYes then
             begin
              DlgSaveParam.Filename := paramfilename;
              if DlgSaveParam.execute then
                WriteParamFile(paramfilename, ModelDef.numparam, par,
                                  ModelDef.numstate, stat, currentresid);
             end
           else
             close;
        end
      else close;
end;

procedure TMainForm.MICalTimeClick(Sender: TObject);
begin
// Ask the user for the time to calculate a steady state at.
  CalTime := strtofloat(InputBox('Steady State Time',
    'Enter the time from the driver file at which to calculate a steady state.',
    floattostr(CalTime)));
  RunComplete := False;
  FmDisplayData.NeedtoReadData := True; // Tell the display form to reread in the output data.
end;

procedure TMainForm.MICalcSSClick(Sender: TObject);
begin
 FmCalculate.showmodal;
end;

procedure TMainForm.SetNumSpecies(anEditBox: TEdit);     // MEL specific
begin
{ if anEditBox.text <> '' then // If a value has been entered.
  begin
    numspp:= strtoint(anEditBox.text); // Set the number of species
    if numspp<1 then numspp:=1;
    if numspp>Maxspecies then numspp:=Maxspecies;
    anEditBox.text := inttostr(numspp);
    counts;
    LblWelcome.Visible:=false;
    LblWelcome.Enabled:=false;
    LblDirections.Visible:=false;
    LblDirections.Enabled:=false;
    EdNumSpecies.Enabled:=false;

    MIFiles.Enabled:=true;
    MIEdit.Enabled:=true;
    MIView.Enabled:=true;
    ParamLabel.Visible:=true;
    Parambox.Visible:=true;
    DriverLabel.Visible:=true;
    DriverBox.Visible:=true;
    OutputLabel.Visible:=true;
    OutputBox.Visible:=true;
    StartLabel.Visible:=true;
    MeStartTime.Visible:=true;
    StopLabel.Visible:=true;
    MeStopTime.Visible:=true;
    StepLabel.Visible:=true;
    MeTimeStep.Visible:=true;
    BtnRun.Visible:=true;
    PresentLabel.Visible:=true;
    PresentBox.Visible:=true;
    BtnReload.Visible:=true;
    if RunningInteractive then
     begin
      Fmparameter.FormDestroy(EdNumSpecies);
      Fmparameter.FormCreate(EdNumSpecies);
      Fmdisplaydata.FormCreate(EdNumSpecies);
      DataForm.FormCreate(EdNumSpecies);
     end;
  end;          }
end;

procedure TMainForm.EdNumSpeciesChange(Sender: TObject);
begin
{ MainForm.SetNumSpecies(MainForm.EdNumSpecies);    }
end;

procedure TMainForm.EdNumSpeciesExit(Sender: TObject);
begin
{ if EdNumSpecies.text = '' then                MainForm.ActiveControl := EdNumSpecies;    }
end;                 // MEL specific

procedure TMainForm.MIViewOutFileClick(Sender: TObject);
begin
 if DlgOpenOutput.execute then
  begin
   if DlgOpenOutput.filename <> '' then
     FmDisplayData.Filename := DlgOpenOutput.filename;
   FmDisplayData.NeedtoReadData := True;
   RunComplete := True;
   UpdateMainForm;
  end;
end;

{procedure TMainForm.METimeStepKeyPress(Sender: TObject; var Key: Char);
begin
 if (Key = Chr(13)) then MeTimeStepExit(Sender);
end;    }

procedure TMainForm.MEStopTimeKeyPress(Sender: TObject; var Key: Char);
begin
 if (Key = Chr(13)) then MeStopTimeExit(Sender);
end;

procedure TMainForm.MEStartTimeKeyPress(Sender: TObject; var Key: Char);
begin
 if (Key = Chr(13)) then MeStartTimeExit(Sender);
end;

procedure TMainForm.MIOpenOptionsClick(Sender: TObject);
begin
 if (Sender as TComponent).name = 'MITimeSteps' then
   lastitem := MITimeSteps
 else if (Sender as TComponent).name = 'MISpecialRun' then
   lastitem := MISpecialRun
 else
   lastitem := MIOutOptions;
 MeStopTimeExit(Sender);          // Fix, why is this necessary?
 FmOptions.ShowModal;
end;

procedure TMainForm.MINormalRunClick(Sender: TObject);
begin
 FmOptions.RbNormalRun.Checked := True;
 FmOptions.UpdateFmRunOptions(MINormalRun);
 MINormalRun.Checked := True;
 RunComplete := False;
 Readytorun := False;
end;

procedure TMainForm.ResetStatesNow(Sender: TObject);
var
 i: integer;
begin
 for i := 1 to ModelDef.numstate do
   begin
     if stat[i].reset then stat[i].value := initialstates[i].value;
   end;
end;

procedure TMainForm.MIAutoChartClick(Sender: TObject); 
begin
 if MIAutoChart.Checked = true then
  begin
   MIAutoChart.checked := false;
   FmDisplayData.autoShowChart := false;
  end
 else
  begin
   MIAutoChart.checked := true;
   FmDisplayData.autoShowChart := true;
  end;
end;

procedure TMainForm.ParamBoxKeyPress(Sender: TObject; var Key: Char);
begin
  if (Key = Chr(13)) then ChooseParamFile(Sender);
end;

procedure TMainForm.DriverBoxKeyPress(Sender: TObject; var Key: Char);
begin
  if (Key = Chr(13)) then ChooseDriver(Sender);
end;

procedure TMainForm.OutputBoxKeyPress(Sender: TObject; var Key: Char);
begin
  if (Key = Chr(13)) then ChooseOutputFile(Sender);
end;

procedure TMainForm.EdNumSpeciesKeyPress(Sender: TObject; var Key: Char);
begin
  if (Key = Chr(13)) then EdNumSpeciesExit(Sender);
end;

procedure TMainForm.ShowProgressBar;
begin
  FmProgress.Caption := modeldef.modelname + ' run progress';
  FmProgress.LblBegin.Caption := floattostr(time_start);
  FmProgress.LblEnd.Caption := floattostr(time_stop);
  FmProgress.CancelProcedure := CancelRun;
  FmProgress.Show;
end;

procedure TMainForm.CancelRun;
begin
  stopRun := True;
  FmDisplayData.autoShowChart := false;
end;

end.
